<?php

namespace filebase\system\event\listener;

use filebase\form\FileAddForm;
use filebase\form\VersionAddForm;
use filebase\form\VersionEditForm;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\exception\UserInputException;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 *
 *
 * @author          Fabian Graf update mipu
 * @copyright       2017 - 2024 Fabian Graf / mipu
 * @license         WBB Support 
 * @package         de.fabihome.filebase.externalFileSize
 */
class ExternalFileSizeListener implements IParameterizedEventListener {

	/**
	 * external filesize
	 * @var double
	 */
	public $externalFileSize = 0.0;

	/**
	 * external filesize unit
	 * @var string
	 */
	public $externalFileSizeUnit = 'byte';


	public function execute($eventObj, $className, $eventName, array &$parameters) {
		$this->$eventName($eventObj);
	}

	protected function assignVariables() {
		WCF::getTPL()->assign([
			'externalFileSize' => $this->externalFileSize,
			'externalFileSizeUnit' => $this->externalFileSizeUnit,
		]);
	}

	protected function validate($eventObj) {
		if ($eventObj->fileType == 'externalURL') {
			if ($this->externalFileSize < 0.01) {
				throw new UserInputException('externalFileSize');
			}
		}
	}

	protected function readData(VersionEditForm $eventObj) {
		if (empty($_POST)) {
			$this->externalFileSize = $eventObj->version->externalFileSize;
			$this->externalFileSizeUnit = $eventObj->version->externalFileSizeUnit;
		}
	}

	protected function readFormParameters() {
		if (isset($_POST['externalFileSize'])) $this->externalFileSize = \floatval($_POST['externalFileSize']);
		if (isset($_POST['externalFileSizeUnit'])) $this->externalFileSizeUnit = StringUtil::trim($_POST['externalFileSizeUnit']);
	}

	protected function save(VersionAddForm $eventObj) {
		$eventObj->additionalFields = array_merge($eventObj->additionalFields, [
			'externalFileSize' => $this->externalFileSize,
			'externalFileSizeUnit' => $this->externalFileSizeUnit
		]);
	}

	protected function saved(FileAddForm $eventObj) {
		if ($eventObj->fileType == 'externalURL') {

			$sql = "UPDATE  filebase" . WCF_N . "_file_version
                                SET     externalFileSize = ?,
                                        externalFileSizeUnit = ?
                                WHERE   fileID = ? ";
			$statement = WCF::getDB()->prepareStatement($sql);
			$statement->execute([
				$this->externalFileSize,
				$this->externalFileSizeUnit,
				$eventObj->objectAction->getReturnValues()['returnValues']->fileID
			]);
		}
	}
}
